#include <iostream>
#include <vector>
#include <float.h>
#include <set>
#include <algorithm>

using namespace std;

struct trkac {
	int x;
	int v;
};

double vreme_preticanja(trkac t1, trkac t2) {
	if (t1.v < t2.v) {
		return DBL_MAX;
	}
	return (double)(t2.x - t1.x) / (t1.v - t2.v);
}

int main()
{

	int n, k;
	cin >> n >> k;

	vector<trkac> trkaci(n);
	for (int i = 0; i < n; i++) {
		cin >> trkaci[i].x;
		cin >> trkaci[i].v;
	}
	sort(trkaci.begin(), trkaci.end(), [](trkac& a, trkac& b) { return a.x < b.x; });

	set<double> preticanja;
	for (int i = 0; i < trkaci.size() - 1; i++) {
		for (int j = i + 1; j < trkaci.size(); j++) {
			preticanja.insert(vreme_preticanja(trkaci[i], trkaci[j]));
		}
	}

	if (preticanja.size() < k - 1) {
		set<double>::iterator it = preticanja.end();
		cout << *(--it);
	}
	else {
		set<double>::iterator it = preticanja.begin();
		advance(it, k - 1);
		cout << *it;
	}
}